package gov.va.genisis2.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.ILookUpDao;
import gov.va.genisis2.service.ILookUpService;

@Service
public class LookUpService implements ILookUpService {

	/**
	 * The lookUpDao
	 * 
	 * */
	@Autowired
	private ILookUpDao lookUpDao;

	/**
	 * This method is used to getLookUpDao.
	 * @return this returns lookUpDao.
	 * 
	 * */
	public ILookUpDao getLookUpDao() {
		return lookUpDao;
	}

	/**
	 * This method is used to setLookUpDao.
	 * @param lookUpDao The lookUpDao.
	 * 
	 * */
	public void setLookUpDao(ILookUpDao lookUpDao) {
		this.lookUpDao = lookUpDao;
	}
	
	/**
	 * This method is used to getStatusId.
	 * @param statusDescription The statusDescription.
	 * @return int This returns StatusId.
	 * 
	 * */
	@Override
	public int getStatusId(String statusDescription) {
		return lookUpDao.getStatusId(statusDescription);
	}

}
